{**********************************************************************
{*
{* BusyBox uMenu -- Version 3.0  (interface)
{*
{* Copyright (c)
{* Apple Computer, Inc.  1986-1989
{* All Rights Reserved.
{*
{* Developer Technical Support Apple II Sample Code
{*
{* This file contains the interface to the code which implements 
{* menus in the busybox program.
{*
{**********************************************************************}

UNIT uMenu;

INTERFACE

USES
       types,
       locator,
       quickdraw,
       fonts,
       INTMATH,
       events,
       memory,
       controls,
       gsos,
       windows,
       lineedit,
       dialogs,
       menus,
       desk,
       STDFILE,
       resources,
    
       uGlobals,
       uUtils,
       uWindow;


procedure DoMenu;      {Execute a menu item}
procedure SetUpMenus;  {Install menus and redraw menu bar}


IMPLEMENTATION

{$R-}

procedure DoQuitItem;

   {Private routine to set Done flag if the "Quit" item was selected}

   begin   {of DoQuitItem}
       Done := true;
   end;    {of DoQuitItem}



procedure DoAboutItem;
    var
        ignore : integer;
   begin   {of DoAboutItem}
        ignore := AlertWindow(4,NIL,Ptr(1));
   end;    {of DoAboutItem}


procedure DoMenu;

   {Procedure to handle all menu selections.  Examines the Event.TaskData
    menu item ID word from TaskMaster (from Event Manager) and calls the
    appropriate routine.  While the routine is running the menu title is
    still highlighted.  After the routine returns, we unhilight the
    menu title.}

   var menuNum : integer;
       itemNum : integer;

   begin   {of DoMenu}

       menuNum := HiWord (Event.wmTaskData);
       itemNum := LoWord (Event.wmTaskData);
   
       case itemNum of
           AboutItem    :  DoAboutItem;
           CloseItem    :  DoCloseTop;
           QuitItem     :  DoQuitItem;
           UndoItem     :  ;
           CutItem      :  ;
           CopyItem     :  ;
           PasteItem    :  ;
           ClearItem    :  ;
       otherwise
           ;
       end;

       HiliteMenu (false,menuNum);     {Unhighlight the menu title}{ *** MAX *** }

   end;    {of DoMenu}



procedure SetUpMenus;

   {Procedure to install our menu titles and their items in the system menu
    bar and to redraw it so we can see them.}

   var height : integer;

   begin   {of SetUpMenus}
        SetSysBar(NewMenubar2(RefIsResource,ref($1000),NIL));
        SetMenuBar(NIL);
        
        FixAppleMenu (AppleMenuID);               {Add DAs to apple menu    }
        height := FixMenuBar;                     {Set sizes of menus       }
        DrawMenuBar;                              {...and draw the menu bar!}
   end;    {of SetUpMenus}

END.
